import { View, FlatList, StyleSheet } from "react-native";
import React from "react";
import SkeletonElement from "../../../SkeletonElement";
import dpr from "../../../../../screens/Utilities/CustomStyleAttribute/dpr";
import { refundStyle } from "../../../../../screens/Profile/MyRefund/RefundRequest/RefundRequestStyle";
const RenderItem = ({ item }) => {
    return (
        <View style={refundStyle.container}>
            <View style={styles.marginTop(30)} >
                <View>
                    <SkeletonElement wrapperStyle={styles.skeletonWrapper(24, 160)} />
                </View>
                <View>
                    <View style={styles.marginEnd}>
                        <SkeletonElement wrapperStyle={styles.skeletonWrapper(50, 40)} />
                    </View>
                </View>
            </View>
            <View  style={styles.marginTop(20)} >
                <View>
                    <SkeletonElement wrapperStyle={styles.skeletonWrapper(24, 160)}/>
                </View>
                <View>
                    <View style={styles.marginEnd}>
                        <SkeletonElement wrapperStyle={styles.skeletonWrapper(50, 40)}/>
                    </View>
                </View>
            </View>
            <View style={styles.marginTop(20)} >
                <View>
                    <SkeletonElement wrapperStyle={styles.skeletonWrapper(24, 160)} />
                </View>
                <View>
                    <View style={styles.marginEnd}>
                        <SkeletonElement wrapperStyle={styles.skeletonWrapper(50, 40)}/>
                    </View>
                </View>
            </View>
            <View style={styles.marginTop(20)} >
                <View>
                    <SkeletonElement wrapperStyle={styles.skeletonWrapper(24, 160)} />
                </View>
                <View>
                    <View style={styles.marginEnd}>
                        <SkeletonElement wrapperStyle={styles.skeletonWrapper(50, 40)} />
                    </View>
                </View>
            </View>
            <View style={styles.marginTop(30)} >
                <View style={styles.alignCenter}>
                    <SkeletonElement wrapperStyle={styles.skeletonWrapper(100, 260)}/>
                </View>
            </View>
            <View style={styles.marginTop(20)}>
                <View>
                    <View style={styles.marginEnd}>
                        <SkeletonElement
                            wrapperStyle={styles.skeletonWrapper(50, 40)}
                        />
                    </View>
                </View>
            </View>
        </View>
    );
};
const RequestRefundSkeleton = () => {
    return (
        <View>
            <FlatList
                data={[1]}
                renderItem={({ item }) => <RenderItem item={item} />}
                keyExtractor={(_, i) => `key-${i}`}
                showsVerticalScrollIndicator={false}
            />
        </View>
    );
};

export default RequestRefundSkeleton;

const styles = StyleSheet.create({
    marginTop: (value) => ({
        marginTop: dpr(value),
    }),
    marginEnd: {
        marginEnd: dpr(15),
    },
    alignCenter: {
        alignItems: "center",
    },
    skeletonWrapper: (height, minusWidth) => ({
        height: dpr(height),
        width: dpr("wf") - dpr(minusWidth),
    }),
});
